using System;

struct Nivo
{
    public int BrojPrepreka { get; set; }
    public int PocetnaVelicinaVojske { get; set; }
    public int[] M { get; set; }
    public int[] A { get; set; }
    public int[] L { get; set; }
    public int[] R { get; set; }
}

class Program
{
    static int MaksimalnaVelicinaVojnike(Nivo nivo)
    {
        int N = nivo.BrojPrepreka;
        int S = nivo.PocetnaVelicinaVojske;
        int[] mi = nivo.M;
        int[] ai = nivo.A;
        int[] li = nivo.L;
        int[] ri = nivo.R;

        int vojska = S;

        for (int i = 0; i < N; i++)
        {
            int opcija1 = vojska * mi[i];
            int opcija2 = vojska + ai[i];

            if (opcija1 < li[i] || opcija1 > ri[i])
                opcija1 = int.MinValue;

            if (opcija2 < li[i] || opcija2 > ri[i])
                opcija2 = int.MinValue;

            if (opcija1 != int.MinValue && opcija2 != int.MinValue)
                vojska = Math.Max(opcija1, opcija2);
            else if (opcija1 != int.MinValue)
                vojska = opcija1;
            else if (opcija2 != int.MinValue)
                vojska = opcija2;
            else
                return int.MinValue;
        }

        return vojska;
    }

    static void Main()
    {
        int T = int.Parse(Console.ReadLine());

        for (int t = 0; t < T; t++)
        {
            
            Nivo nivo = UnesiNivo();
            int rezultat = MaksimalnaVelicinaVojnike(nivo);
            Console.WriteLine(rezultat == int.MinValue ? "nemoguce" : rezultat.ToString());
        }
    }

    static Nivo UnesiNivo()
    {
        string[] linija = Console.ReadLine().Split();
        return new Nivo
        {
            BrojPrepreka = int.Parse(linija[0]),
            PocetnaVelicinaVojske = int.Parse(linija[1]),
            M = Array.ConvertAll(Console.ReadLine().Split(), int.Parse),
            A = Array.ConvertAll(Console.ReadLine().Split(), int.Parse),
            L = Array.ConvertAll(Console.ReadLine().Split(), int.Parse),
            R = Array.ConvertAll(Console.ReadLine().Split(), int.Parse)
        };
    }
}